<?php
/**
 * index.php
 *
 * The main template file for white theme.
 * This is always used when there is no specific template like archive.php, category.php.
 *
 * @package WordPress
 * @subpackage WhiteShow
 * @since 1.0
 * @version 1.1
 */
?>

<?php get_header(); ?>

<div id="primary" class="l-main content-area">
  <main id="main" class="site-main" role="main">
    <?php if ( have_posts() ) : ?>
      <?php if ( ! is_home() ) : ?>
        <header class="page-header">
          <?php 
            the_archive_title( '<h1 class="heading-medium page-title">「', '」の記事一覧</h1>' );

            if ( is_category() || is_tag() ) {
              $desc = get_the_archive_description();

              if ( $desc ) {
                echo '<div class="page-description">' . $desc . '</div>';
              } 
            }
          ?>
        </header>
      <?php endif; ?>

      <div class="entry-list">
        <?php 
          while ( have_posts() ) {
            the_post();
            get_template_part( 'template-parts/post/content' );
          }
        ?>
      </div>
      
      <?php
        the_posts_pagination ( array(
          'screen_reader_text'  => '投稿のナビゲーション',
        ) );
      ?>
    <?php else: ?>
      <section class="no-result not-found">
        <header class="page-header">
          <h1 class="heading-big page-title">Nothing Found</h1>
        </header>

        <div class="page-content">
          おさがしの記事は見つかりませんでした。 
        </div>
      </section>
    <?php endif; ?>
  </main>
</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>