<?php
/**
 * search.php
 *
 * The template for displaying search results.
 *
 * @package WordPress
 * @subpackage WhiteShow
 * @since 1.1
 * @version 1.0
 */
?>

<?php get_header(); ?>

<div id="primary" class="l-main content-area">
  <main id="main" class="site-main" role="main">
    <?php if( have_posts() ) : ?>
      <header class="page-header">
        <h1 class="heading-medium page-title">「<span><?php echo get_search_query(); ?></span>」で検索した結果</h1>
        <p class="page-description">
          <span><?php echo $wp_query->found_posts; ?></span>件の記事が見つかりました。
        </p>
      </header>

      <div class="entry-list">
        <?php
          while ( have_posts() ) {
            the_post();
            get_template_part( 'template-parts/post/content' );
          }
        ?>
      </div>
      
      <?php
        the_posts_pagination( array(
          'screen_reader_text'  => '投稿のナビゲーション',
        ) );
      ?>
    <?php else: ?>
      <section class="no-result not-found">
        <header class="page-header">
          <h1 class="heading-big page-title">Nothing Found</h1>
        </header>

        <div class="page-content">
          「<span><?php echo get_search_query(); ?></span>」で検索しましたが、何も見つかりませんでした。検索ワードを変えてもう一度お試しください。 
        </div>
      </section>
    <?php endif; ?>
  </main>
</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
