<?php
/**
 * content.php
 *
 * Template part for displaying a post.
 * This is used in Blog Index Page and Search Results.
 *
 * @package WordPress
 * @subpackage WhiteShow
 * @since 1.1
 * @version 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
  <header class="entry-header">
    <time class="tiny-text entry-date"><?php echo get_the_date(); ?></time>
    <?php the_title( 
      '<h2 class="heading-big entry-title"><a href="' . esc_url( get_permalink() ) . '">',
      '</a></h2>'
    ); ?> 
  </header>

  <?php if( has_post_thumbnail() ) : ?>
    <div class="entry-thumbnail">
      <a href="<?php the_permalink(); ?>">
        <?php the_post_thumbnail( 'post-thumbnail' ); ?>
      </a>
    </div>
  <?php endif; ?>

  <div class="entry-content">
    <?php the_content( '<span class="btn btn-primary">Continue Reading</span>' ); ?>
  </div>
</article> 